/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.search;

import org2.eclipse.php.internal.core.CoreMessages;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org2.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org2.eclipse.php.internal.core.corext.ASTNodes;
import org2.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org2.eclipse.php.internal.core.search.IOccurrencesFinder;
import org2.eclipse.php.internal.core.search.Messages;

public class MethodExitsFinder
extends AbstractOccurrencesFinder {
    private static final String EXIT_POINT_OF = CoreMessages.getString("MethodExitsFinder.0");
    public static final String ID = "MethodExitsFinder";
    private FunctionDeclaration fFunctionDeclaration;
    private ASTNode fExitPointNode;

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.fExitPointNode = node;
        if (this.isExitExecutionPath(node)) {
            this.fFunctionDeclaration = node.getType() == 29 ? (FunctionDeclaration)node : (FunctionDeclaration)ASTNodes.getParent(node, 29);
            if (this.fFunctionDeclaration == null) {
                return "MethodExitsFinder_no_return_type_selected";
            }
            return null;
        }
        this.fDescription = "MethodExitsFinder_occurrence_exit_description";
        return this.fDescription;
    }

    private final boolean isExitExecutionPath(ASTNode node) {
        return node != null && (node.getType() == 50 || node.getType() == 57 || node.getType() == 29);
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = Messages.format(EXIT_POINT_OF, this.fFunctionDeclaration.getFunctionName().getName());
        this.fFunctionDeclaration.accept(this);
        int offset = this.fFunctionDeclaration.getStart();
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, 8, this.getOccurrenceType(null), ""));
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 7;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength() - 1, this.getOccurrenceType(null), this.fDescription));
        return super.visit(node);
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength() - 1, this.getOccurrenceType(null), this.fDescription));
        return true;
    }

    @Override
    public Program getASTRoot() {
        return this.fASTRoot;
    }

    @Override
    public String getElementName() {
        return this.fFunctionDeclaration.getFunctionName().getName();
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getJobLabel() {
        return "MethodExitsFinder_job_label";
    }

    @Override
    public int getSearchKind() {
        return 7;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return "MethodExitsFinder_label_plural";
    }

    @Override
    public String getUnformattedSingularLabel() {
        return "MethodExitsFinder_label_singular";
    }
}

